#include <bits/stdc++.h>
using namespace std;

static const long long INF = (1LL<<62);

struct SegMin {
    int n;
    vector<long long> t;
    SegMin(int n=0){ init(n); }
    void init(int n_) {
        n = 1;
        while(n < n_) n <<= 1;
        t.assign(2*n, INF);
    }
    void update(int pos, long long val) {
        pos += n;
        t[pos] = min(t[pos], val);
        for(pos >>= 1; pos; pos >>= 1)
            t[pos] = min(t[pos<<1], t[pos<<1|1]);
    }
    // query min on [l, r)
    long long query(int l, int r) const {
        long long res = INF;
        l += n; r += n;
        while(l < r) {
            if(l & 1) res = min(res, t[l++]);
            if(r & 1) res = min(res, t[--r]);
            l >>= 1; r >>= 1;
        }
        return res;
    }
};

struct Mast {
    long long x, h;
    int id;
};

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n;
    cin >> n;
    vector<long long> x(n+1), h(n+1);
    for(int i=1;i<=n;i++){
        // ulaz je u dve linije? na slici piše dve linije nizova,
        // ali cesto daju i kao parove. Ovde citamo kao dva niza:
    }

    // Pokušaj citanja kao dva niza:
    // Ako je format stvarno "x1..xn" pa "h1..hn", ovo je tacno.
    for(int i=1;i<=n;i++) cin >> x[i];
    for(int i=1;i<=n;i++) cin >> h[i];

    vector<Mast> a;
    a.reserve(n);
    for(int i=1;i<=n;i++) a.push_back({x[i], h[i], i});

    sort(a.begin(), a.end(), [](const Mast& A, const Mast& B){
        return A.x < B.x;
    });

    int N = n;
    vector<int> pos(N+1);
    vector<long long> xs(N), hs(N);
    for(int i=0;i<N;i++){
        xs[i] = a[i].x;
        hs[i] = a[i].h;
        pos[a[i].id] = i;
    }

    // sortiramo indekse po visini opadajuce
    vector<int> ids(N);
    iota(ids.begin(), ids.end(), 1);
    sort(ids.begin(), ids.end(), [&](int i, int j){
        if(h[i] != h[j]) return h[i] > h[j];
        return i < j;
    });

    SegMin segL(N), segR(N); // segL cuva (-x - h), segR cuva (x - h)

    vector<long long> ans(N+1, -1);

    int ptr = 0;
    while(ptr < N) {
        int start = ptr;
        long long curH = h[ids[ptr]];
        while(ptr < N && h[ids[ptr]] == curH) ptr++;
        int end = ptr;

        // ubaci sve iz ove grupe u aktivne (h >= curH)
        for(int k=start;k<end;k++){
            int id = ids[k];
            int p = pos[id];
            segL.update(p, -xs[p] - hs[p]);
            segR.update(p,  xs[p] - hs[p]);
        }

        // upiti za ovu grupu, uz izuzimanje samog sebe (p)
        for(int k=start;k<end;k++){
            int id = ids[k];
            int p = pos[id];

            long long best = INF;

            // levo: [0, p)
            if(p > 0) {
                long long mn = segL.query(0, p);
                best = min(best, xs[p] + mn);
            }
            // desno: (p, N) == [p+1, N)
            if(p + 1 < N) {
                long long mn = segR.query(p+1, N);
                best = min(best, -xs[p] + mn);
            }

            if(best == INF) {
                ans[id] = -1;
            } else {
                long long val = best + h[id];
                if(val < 0) val = 0;
                ans[id] = val;
            }
        }
    }

    for(int i=1;i<=n;i++){
        cout << ans[i] << "\n";
    }
    return 0;
}